import string
import sys

max_d = 9
#max_el = 32
max_el = 0

def gen_built_sources_am():
    # plain C, sequential case
    built_sources = []
    for d in range(2,max_d+1):
        built_sources.append('autogenerated_c-sequential_deg_{0}.c'.format(d))
        built_sources.append('autogenerated_c-tester_deg_{0}.c'.format(d))
        
    print("plain_c_sources = ", string.join(built_sources, ' \\\n\t'))

# C boilerplate, ASM + SIMD case
    built_sources = []
    #for el in range(max_el+1):
    #    built_sources.append('autogenerated_c-simd-with-asm_deg_2_el_{0}.c'.format(el))

    for d in range(2,max_d+1):
        for T in [2,3,4]:
            built_sources.append('autogenerated_c-simd-with-asm_deg_{0}_T_{1}_el_0.c'.format(d,T))

    print("asm_c_sources= ", string.join(built_sources, ' \\\n\t'))

# assembly code, ASM + SIMD case
    built_sources = []
    #for el in range(max_el+1):
    #    built_sources.append('autogenerated_asm_deg_2_el_{0}.s'.format(el))
    for d in range(2,max_d+1):
        for T in [2,3,4]:
            built_sources.append('autogenerated_asm_deg_{0}_T_{1}_el_0.s'.format(d,T))
    print( "asm_sources = ", string.join(built_sources, ' \\\n\t'))

def gen_include():
    print( '#include <inttypes.h>')
    print( '#include <emmintrin.h>')
    print( '#include "fes.h"')
    print( '' )

    # plain C stuff
    for d in range(2,max_d+1):
        print( 'void exhaustive_ia32_deg_{0}(LUT_t LUT, int n, pck_vector_t F[], solution_callback_t callback, void* callback_state, int verbose); // autogenerated_sequential_deg_{0}.c'.format(d))
        print( 'pck_vector_t packed_eval_deg_{0}(LUT_t LUT, int n, pck_vector_t F[], uint64_t i); // autogenerated_tester_deg_{0}.c'.format(d))
    print( '')

    # SIMD stuff
    print( '#ifdef HAVE_SSE2')
    for d in range(2,max_d+1):
        for T in [2,3,4]:
            print( 'void exhaustive_sse2_deg_{0}_T_{1}_el_0(LUT_t LUT, int n, pck_vector_t nonsimd_F[], solution_callback_t callback, void* callback_state, int verbose); // autogenerated_simd_deg_{0}_T_{1}_el_0.c'.format(d,T))


    print( '#ifdef HAVE_64_BITS' )
    for d in range(2,max_d+1):
        for T in [2,3,4]:
            print( 'extern void func_deg_{0}_T_{1}_el_0(__m128i *F, uint64_t *F_sp, void *buf, uint64_t *num, uint64_t idx); // autogenerated_asm_deg_{0}_T_{1}_el_0.s'.format(d,T))

    print( '#endif')
    print( '#endif')

    print( '')
        

if sys.argv[1] == 'built_sources.am':
    gen_built_sources_am()
elif sys.argv[1] == 'all_functions.h':
    gen_include()
