
window.onload=function(){

	$("text").onkeyup = showDivContent;
	$("button1").onclick = function(){
		alert($("cell_resizer").innerHTML);

	} 
};


//Checks if array contains value. Value is a char.
function DoesArrayContain(array, value){
	for (var i = 0; i < array.length; i++){
		if (array[i] == value){
			return true;
		}
	}
	
	return false;
}



/*This function strips out comment blocks that begin and end with commentText. It turns the chars in between into a nonparen/bracket/brace to retain the length of 
the comment and keep highlighting where it should be.

*/
function stripBlockComments(commentText, textToStrip){
	var pieces = textToStrip.split(commentText);
	var textToReturn = "";
	var comment = "";

	for(var k = 0; k < commentText.length; k++){
		comment += "X";
	}
	for(var i = 0; i < pieces.length; i++){
		if( i % 2 == 0){
			textToReturn += pieces[i] + comment;
		}else{
				textToReturn += convert(pieces[i]) + comment;
		}


	}
	return textToReturn;
}

/*
  Replaces all text with an X. Subfunction called by stripBlockComments
*/
function convert(text){
	return text.replace(/[^ \n]/g, 'X');

}


/*This returns an array of numerical references to the unmatched characters in the text. This was initially a more general function so that you could specify the open/close characters of each matching set that you wanted, but that required three passes through the text input by the user; this requires only one pass through the text.*/

function findUnmatchedCharacters(inputText){
	var parenCount = 0;
	var braceCount = 0;
	var brackCount = 0;
	var output = "";
	var OBRACE = "[";
	var CBRACE = "]";
	var OBRACK = "{";
	var CBRACK = "}";
	var OPAREN = "(";
	var CPAREN = ")";

	var obrace = new Array();
	var cbrace = new Array();

	var obrack = new Array();
	var cbrack = new Array();

	var oparen = new Array();
	var cparen = new Array();
		
	// Pass 1 - scan for unmatched parens.
	// Save indices of unmatched parens for later maniuplation	
	for (var i = 0; i < inputText.length; i++){
		var currentChar = inputText.charAt(i);
	
	
		if ( OPAREN == currentChar ){
			oparen.push(i);
			parenCount++;
		}else if ( CPAREN == currentChar ){
			if (parenCount > 0){
				parenCount--;
				oparen.pop();
			}
			else{
				cparen.push(i);
			}
		}else if ( OBRACK == currentChar ){
                        obrack.push(i);
                        brackCount++;
                }else if ( CBRACK == currentChar ){
                        if (brackCount > 0){
                                brackCount--;
                                obrack.pop();
                        }
                        else{
                                cbrack.push(i);
                        }
                }else if ( OBRACE == currentChar ){
                        obrace.push(i);
                        braceCount++;
                }else if ( CBRACE == currentChar ){
                        if (braceCount > 0){
                                braceCount--;
                                obrace.pop();
                        }
                        else{
                                cbrace.push(i);
                        }
                }


	}

	return obrace.concat(cbrace, obrack, cbrack, oparen, cparen); //only one array of references is needed; this cuts down on checks later

}




/****
 This function sorts numbers from high to low. 
****/
function sortNumber(b, a){
	return a - b;
}



/* This highlights the string according to references given in the the array. */
function highlightTry2(inputText, references){
	references.sort(sortNumber);
	var buildingString = inputText;

	while(references.length > 0){
		var index = references.shift();
		var insertPortion = "<span class='bad'>" + inputText.charAt(index) + "</span>";
		var secondPart = buildingString.substr(index + 1);
		var firstPart = buildingString.substr(0, index);
		buildingString = firstPart + insertPortion + secondPart;
	}
	
	return buildingString;
}


function showDivContent(){
	cell_input_resize("text"); //makes sure all textareas/divs are large enough for their content

	var cell_content = $("cell_resizer").innerHTML;

	var references = findUnmatchedCharacters(cell_content);

	if(references.length > 0)
		$("cell_resizer").innerHTML = highlightTry2(cell_content, references);

}


/**
A shorter, quicker way to get elements.

**/

function $(id){
	return document.getElementById(id);
}

    /*
    Resize the given input cell so that it has the right
    number of rows for the number of rows currently typed into
    the input cell.

    INPUT:
        id -- a cell id
    OUTPUT:
        changes the height of the corresponding DOM object to fit the input

    ALGORITHM:
    Create a hidden div with the same style as the textarea, then copy
    all the text into it, set the height of the textarea in pixels
    based on the height of the div, then delete the div.
    */


function cell_input_resize(id) {

    var resizer = $("cell_resizer");
    var cell_input = $(id);
    resizer.style.maxWidth = cell_input.offsetWidth + 'px';
    resizer.style.width = cell_input.offsetWidth - 1 + 'px'; // because of the border on the textarea, we need to set the div to be slightly smaller than the textarea, otherwise the last highlight character ends up going outside the box and throwing off the next line when it/if wraps
    cell_input.value = cell_input.value.replace(/\t/g, '    ');
    var content = cell_input.value;
    content = content.replace(/^ /, '&nbsp;');
    content = content.replace(/\n /, '\n&nbsp;');

    content = stripBlockComments('"""', content );
    content = content.replace(/</g,'&lt;'); //important to not mess up my tags in my div
    content = content.replace(/\r?\n/g,'<br>'); //adding in break lines where user pressed enter
    content = content.replace(/<br> /g, '<br>&nbsp;');
    content = content.replace(/\s\s/g,'&nbsp; ') + '&nbsp;';
    content = content.replace(/\s\s/g,'&nbsp; ') + '&nbsp;'; //this must be done twice in order to ensure that a line ending with three spaces does not end up as '&nbsp;  '
    resizer.innerHTML = content;

  
    cell_input.style.height = (resizer.offsetHeight + 30) + 'px'; //to make sure there is no scroll bar in the textarea. this was very annoying.
	




    return;
}


