

from mako.template import Template

from chatroom import * 

import sys

import string,cgi,time,urllib
from os import curdir, sep
from BaseHTTPServer import BaseHTTPRequestHandler, HTTPServer

argv = sys.argv
ChatRoom.SetEnv(argv[1],argv[2],argv[3])

class SageChatServerHandler(BaseHTTPRequestHandler):
    chat_rooms = []

    def do_GET(self):
        try:
            if self.path == ('/chat') or self.path == ('/chat/'):
                cell_template = Template(filename='chat_lobby.html')
                self.wfile.write( cell_template.render() )
            elif self.path.startswith('/chat'):
                self.success_headers()                
                path_parts = self.path.split('/')
                self.chat_room_template( path_parts[2] , self.wfile )
                
            if self.path == ('/jquery.js'):
                self.success_headers()
                self.wfile.write(open("jquery.js").read())
            if self.path == ('/shortcuts.js'):
                self.success_headers()
                self.wfile.write(open("shortcuts.js").read())
            if self.path.startswith('/history'):
                self.success_headers()                
                path_parts = self.path.split('/')
                cell_template = Template(filename='_sage_history.html')
                self.wfile.write( cell_template.render(chat_room_name=path_parts[2] ))
            return
                
        except IOError:
            self.send_error(404,'File Not Found: %s' % self.path)
    
    def do_POST(self):
        try:
            if self.path.startswith('/chat'):      
                length = int(self.headers.getheader('content-length'))
                if length:
                    text = self.rfile.read(length)
                    params = cgi.parse_qs(text)
                    
                room_name = self.path.split('/')[2]              
                room = ChatRoom.For(room_name)   
                sage_command_result = room.add_message(params['message'][0])
                
                self.success_headers()
                cell_template = Template(filename='_sage_cell.html')
                self.wfile.write(cell_template.render(message=sage_command_result))
        except :
            pass

    def success_headers(self):
        """docstring for success_headers"""
        self.send_response(200)
        self.send_header('Content-type',  'text/html')
        self.end_headers()

    def chat_room_template(self , room_name , file ):
        """docstring for chat_room_template"""
        mytemplate = Template(filename='chat_room.html')
        file.write(mytemplate.render(chat_room_name=room_name))
        

def main():
    try:
        server = HTTPServer(('', 3000), SageChatServerHandler)
        print 'started httpserver...'
        server.serve_forever()
    except KeyboardInterrupt:
        print '^C received, shutting down server'
        server.socket.close()

if __name__ == '__main__':
    main()

