/*
 * myStrings.h
 * ProfHuster
 * 2018-01-20
 * 
 * Small routines to do string utilities. These avoid using the 
 * String library
 */
#include<Arduino.h>
#include "myStrings.h"

/*
 * Reads the Serial into a buffer until the ending character is read
 */
int readSerialUntil(char *inBuffer, int bufferSize, char endChar){
  bool found = false;
  int i = 0;
  while(Serial.available() && i < bufferSize-1){
    char readChar = Serial.read();
    inBuffer[i] = readChar;
    i++;
    if(readChar == endChar){
      found = true;
      break;
    }
  }
  inBuffer[i] = 0;
  return found;
}

// converts any lower case letters into uppercase.
void toUpperCase(char *inBuffer){
  for(int i = 0; inBuffer[i] != 0; i++){
    if(inBuffer[i] >= 'a' and inBuffer[i] <= 'z'){
      inBuffer[i] &= ~0x20;
    }
  }
}

// search a string for a word
bool found(char *buf, const char *word0){
  int lenBuf = 0;
  while(buf[lenBuf] != 0)
    lenBuf++;
  int lenWord = 0;
  while(word0[lenWord] != 0)
    lenWord++;
  for(int i = 0; i < lenBuf; i++){
    int j = 0;
    while(j < lenWord && i + j < lenBuf) {
      if(buf[i+j] != word0[j])
        break;
      j++;
    }
    if(j == lenWord)
      return true;
  }
  return false;
}

